/******************************************************************************
 *
 * Copyright (c) 2004 PalmSource, Inc. All rights reserved.
 *
 * File: PNOMain.c
 *
 * Description:
 *    PACE byte-swaps userData68KP (but not what it points to!) so it's ready 
 *    to be dereferenced.  PACE also byte-swaps the 4-byte return value, so the 
 *    calling function receives back the same pointer it passed in.
 *
 *    The PNOlet entry point needs to be the first function in the file.
 *
 *****************************************************************************/

#define __OS5DBG__
#include <PceNativeCall.h>
#include <AdnDebugMgr.h>
#include <ByteOrderUtils.h>
#include "example_data_type.h"

// copied from CoreTraps.h
#define sysTrapMemPtrNew	0xA013 // we need this in order to call into MemPtrNew


/************************************************************************
 * This PNOMain sample is an example of a most trivial PNOlet; it simply 
 * returns the same pointer it receives.  
 ************************************************************************/
#ifdef __cplusplus
	extern "C"
#endif
unsigned long PNOMain(const void *, void *, Call68KFuncType *);


unsigned long PNOMain(const void *emulStateP, void *userData68KP, Call68KFuncType *call68KFuncP)
{
	AdnDebugEnableSet(kAdnEnableMasterSwitch | kAdnEnableDebugIndicator | kAdnEnableFullDebugging | kAdnEnableShowSafeFatalAlerts);
	AdnDebugNativeRegister('appl', '???CREATOR_ID???', 'ARMC', 0x1000);
	AdnDebugBreak();
	return (unsigned long)userData68KP;
}



/************************************************************************
This PNOlet sample makes a call (through PACE) to MemPtrNew to allocate a buffer.
The arguments to the OS function (here just size) must be on the stack, and must 
be in big-endian format.

unsigned long PNOMain(const void *emulStateP, void *userData68KP, Call68KFuncType *call68KFuncP)
{
	AdnDebugEnableSet(kAdnEnableMasterSwitch | kAdnEnableDebugIndicator | kAdnEnableFullDebugging | kAdnEnableShowSafeFatalAlerts);
	AdnDebugNativeRegister('appl', '???CREATOR_ID???', 'ARMC', 0x1000);
	AdnDebugBreak();

	unsigned long  size;     // UInt32, must be stack based
	unsigned char* bufferP;  // array of Byte
	unsigned char  i;        // Byte
		
	// set the size to 10 bytes, byte swapped so it's in big-endian format
	// This will be the argument to MemPtrNew().
	size = EndianSwap32(0x0000000AL);   // == 10 in big endian

	// a more clever but less-readable equivalent is:
	// size = 0x0A000000L;
	
	// call MemPtrNew, using the 4 bytes of size directly from the stack
	// The 4 specifies the size of the arguments, and we need to OR the size
	// with kPceNativeWantA0 because the return value is a pointer type.
	bufferP = (unsigned char *)(
				(call68KFuncP)(emulStateP, PceNativeTrapNo(sysTrapMemPtrNew), &size, 4 | kPceNativeWantA0));

	// just for fun, lets do something with the bytes in the buffer
	for (i = 0; i < 9; i++) bufferP[i] = i+'A';  // write in "ABCDEFGHI"
	bufferP[9] = 0;                              // force in the null string terminator
		
	return (unsigned long)bufferP;  // return a pointer to the buffer
}
************************************************************************/


/************************************************************************
This PNOlet sample converts byte endianness.

unsigned long PNOMain(const void *emulStateP, void *userData68KP, Call68KFuncType *call68KFuncP)
{
	AdnDebugEnableSet(kAdnEnableMasterSwitch | kAdnEnableDebugIndicator | kAdnEnableFullDebugging | kAdnEnableShowSafeFatalAlerts);
	AdnDebugNativeRegisterAddr('appl', '???CREATOR_ID???', 'ARMC', 0x1000);
	AdnDebugBreak();

	ExampleStructType* exampleData68KP = (ExampleStructType*)userData68KP;
	unsigned long number1;
	unsigned long number2;
	
	// make a local copies that are guaranteed to be 4-byte-aligned
	number1 = Read68KUnaligned32(&(exampleData68KP->number1));
	number2 = Read68KUnaligned32(&(exampleData68KP->number2));
	
	// add the two together and return the result
	return (unsigned long)(number1 + number2);
}
************************************************************************/

